implementation module menuevent


//	Clean Object I/O library, version 1.1

//	menuevent defines the DeviceEventFunction for the menu device.
//	This function is placed in a separate module because it is platform dependent.


import StdBool, StdInt, StdList, StdTuple
import clCrossCall, intrface, osmenu
import devicefunctions, iostate, menuaccess, windowaccess


menueventFatalError :: String String -> .x
menueventFatalError function error
	= FatalError function "menuevent" error


/*	menuEvent filters the scheduler events that can be handled by this menu device.
	For the time being no timer menu elements are added, so these events are ignored.
*/
menuEvent :: !(SchedulerEvent i o) !(IOSt .l .p) -> (!Bool,!Maybe (DeviceEvent i o),!SchedulerEvent i o,!IOSt .l .p)
menuEvent schedulerEvent=:(ScheduleOSEvent osEvent _) ioState
	| not (isMenuOSEvent osEvent)
	= (False,Nothing,schedulerEvent,ioState)
	# (tb,ioState)		= getIOToolbox ioState
	# (mDevice,ioState)	= IOStGetDevice MenuDevice ioState
	  menus				= MenuSystemStateGetMenuHandles mDevice
	# (myEvent,replyToOS,deviceEvent,menus,tb)
	  					= filterOSEvent osEvent menus tb
	# ioState			= IOStSetDevice (MenuSystemState menus) ioState
	# ioState			= setIOToolbox tb ioState
	  schedulerEvent	= if (isJust replyToOS) (ScheduleOSEvent osEvent (fromJust replyToOS)) schedulerEvent
	= (myEvent,deviceEvent,schedulerEvent,ioState)
where
	isMenuOSEvent :: !OSEvent -> Bool
	isMenuOSEvent {ccMsg=CcWmCOMMAND}	= True
	isMenuOSEvent _						= False

menuEvent schedulerEvent=:(ScheduleMsgEvent msgEvent) ioState
	# (ioId,ioState)	= IOStGetIOId ioState
	| ioId<>recLoc.rlIOId || recLoc.rlDevice<>MenuDevice
	= (False,Nothing,schedulerEvent,ioState)
	# (mDevice,ioState)	= IOStGetDevice MenuDevice ioState
	  menus				= MenuSystemStateGetMenuHandles mDevice
	  (found,menus)		= hasMenuHandlesMenu recLoc.rlParentId menus
	  deviceEvent		= if found (Just (ReceiverEvent msgEvent)) Nothing
	# ioState			= IOStSetDevice (MenuSystemState menus) ioState
	= (found,deviceEvent,schedulerEvent,ioState)
where
	recLoc				= getMsgEventRecLoc msgEvent
	
	hasMenuHandlesMenu :: !Id !(MenuHandles .ps) -> (!Bool,!MenuHandles .ps)
	hasMenuHandlesMenu menuId mHs=:{mMenus}
		# (found,mMenus)= UContains (eqMenuId menuId) mMenus
		= (found,{mHs & mMenus=mMenus})
	where
		eqMenuId :: !Id !(MenuStateHandle .ps) -> (!Bool,!MenuStateHandle .ps)
		eqMenuId theId msH
			# (mId,msH)	= menuStateHandleGetMenuId msH
			= (theId==mId,msH)

menuEvent schedulerEvent ioState
	= (False,Nothing,schedulerEvent,ioState)


/*	filterOSEvent filters the OSEvents that can be handled by this menu device.
*/
filterOSEvent :: !OSEvent !(MenuHandles .ps) !*OSToolbox -> (!Bool,!Maybe [Int],!Maybe (DeviceEvent i o),!MenuHandles .ps,!*OSToolbox)

/*	CcWmCOMMAND returns the selected menu item.
	This item is identified by:
	-	the top level menu Id,
	-	a possibly empty list of parent sub menus. This list is given by zero based indices starting from the top level menu.
	-	in the parent (sub) menu, the zero based index of the item.
	Only MenuItemHandle and SubMenuHandle elements increase the index; all other elements don't.
*/
filterOSEvent {ccMsg=CcWmCOMMAND,p1=item,p2=mods} menus=:{mEnabled,mMenus=mHs} tb
	| not mEnabled
		= (False,Nothing,Nothing,menus,tb)
	# (found,deviceEvent,mHs,tb)= getSelectedMenuStateHandlesItem item mods mHs tb
	= (found,Nothing,deviceEvent,{menus & mMenus=mHs},tb)
where
	getSelectedMenuStateHandlesItem :: !Int !Int ![MenuStateHandle .ps] !*OSToolbox
			  -> (!Bool,!Maybe (DeviceEvent i o),![MenuStateHandle .ps],!*OSToolbox)
	getSelectedMenuStateHandlesItem item mods msHs tb
		| isEmpty msHs
		= (False,Nothing,msHs,tb)
		# (msH,msHs)				= HdTl msHs
		# (found,menuEvent,msH,tb)	= getSelectedMenuStateHandleItem item mods msH tb
		| found
		= (found,menuEvent,[msH:msHs],tb)
		# (found,menuEvent,msHs,tb)	= getSelectedMenuStateHandlesItem item mods msHs tb
		= (found,menuEvent,[msH:msHs],tb)
	where
		getSelectedMenuStateHandleItem :: !Int !Int !(MenuStateHandle .ps) !*OSToolbox
				  -> (!Bool,!Maybe (DeviceEvent i o),!MenuStateHandle .ps, !*OSToolbox)
		getSelectedMenuStateHandleItem item mods msH=:(MenuLSHandle mlsH=:{mlsHandle=mH=:{mSelect,mHandle,mMenuId,mItems}}) tb
			| not mSelect
			= (False,Nothing,msH,tb)
			# (found,menuEvent,_,_,itemHs,tb)	= getSelectedMenuElementHandlesItem item mHandle mMenuId mods [] 0 mItems tb
			= (found,menuEvent,MenuLSHandle {mlsH & mlsHandle={mH & mItems=itemHs}},tb)
		where
			getSelectedMenuElementHandlesItem :: !Int !OSMenu !Id !Int ![Int] !Int ![MenuElementHandle .ls .ps] !*OSToolbox
									-> (!Bool,!Maybe (DeviceEvent i o),![Int],!Int,![MenuElementHandle .ls .ps],!*OSToolbox)
			getSelectedMenuElementHandlesItem item mH menuId mods parents zIndex itemHs tb
				| isEmpty itemHs
				= (False,Nothing,parents,zIndex,itemHs,tb)
				# (itemH,itemHs)							= HdTl itemHs
				# (found,menuEvent,parents,zIndex,itemH,tb)	= getSelectedMenuElementHandle item mH menuId mods parents zIndex itemH tb
				| found
				= (found,menuEvent,parents,zIndex,[itemH:itemHs],tb)
				# (found,menuEvent,parents,zIndex,itemHs,tb)= getSelectedMenuElementHandlesItem item mH menuId mods parents zIndex itemHs tb
				= (found,menuEvent,parents,zIndex,[itemH:itemHs],tb)
			where
				getSelectedMenuElementHandle :: !Int !OSMenu !Id !Int ![Int] !Int !(MenuElementHandle .ls .ps) !*OSToolbox
								   -> (!Bool,!Maybe (DeviceEvent i o),![Int],!Int, !MenuElementHandle .ls .ps, !*OSToolbox)
				
				getSelectedMenuElementHandle item mH menuId mods parents zIndex itemH=:(MenuItemHandle {mOSMenuItem,mItemId}) tb
					| item==mOSMenuItem
					= (True,Just (MenuTraceEvent {mtId=menuId,mtParents=parents,mtItemNr=zIndex,mtModifiers=toModifiers mods}),parents,zIndex+1,itemH,tb)
					= (False,Nothing,parents,zIndex+1,itemH,tb)
				
				getSelectedMenuElementHandle item mH menuId mods parents zIndex itemH=:(SubMenuHandle submenuH=:{mSubSelect,mSubHandle,mSubItems}) tb
					| not mSubSelect
					= (False,Nothing,parents,zIndex+1,itemH,tb)
					# (found,menuEvent,parents1,_,itemHs,tb)
								= getSelectedMenuElementHandlesItem item mSubHandle menuId mods (parents++[zIndex]) 0 mSubItems tb
					  itemH		= SubMenuHandle {submenuH & mSubItems=itemHs}
					  parents	= if found parents1 parents
					= (found,menuEvent,parents,zIndex+1,itemH,tb)
				
				getSelectedMenuElementHandle item mH menuId mods parents zIndex (RadioMenuHandle rH=:{mRadioSelect,mRadioItems=itemHs,mRadioIndex}) tb
					# (nrRadios,itemHs)	= Ulength itemHs
					| not mRadioSelect
					= (False,Nothing,parents,zIndex+nrRadios,RadioMenuHandle {rH & mRadioItems=itemHs},tb)
					# (found,menuEvent,parents,zIndex1,itemHs,tb)	= getSelectedMenuElementHandlesItem item mH menuId mods parents zIndex itemHs tb
					| not found
					= (found,menuEvent,parents,zIndex1,RadioMenuHandle {rH & mRadioItems=itemHs},tb)
					# curIndex	= mRadioIndex
					  newIndex	= zIndex1-zIndex
					| curIndex==newIndex
					= (found,menuEvent,parents,zIndex1,RadioMenuHandle {rH & mRadioItems=itemHs},tb)
					# curH		= getMenuItemOSMenuItem (itemHs!!(curIndex-1))
					  newH		= getMenuItemOSMenuItem (itemHs!!(newIndex-1))
					# tb		= OSMenuItemCheck False mH curH tb
					# tb		= OSMenuItemCheck True  mH newH tb
					= (found,menuEvent,parents,zIndex1,RadioMenuHandle {rH & mRadioItems=itemHs,mRadioIndex=newIndex},tb)
				where
					getMenuItemOSMenuItem :: !(MenuElementHandle .ls .ps) -> OSMenuItem
					getMenuItemOSMenuItem (MenuItemHandle {mOSMenuItem}) = mOSMenuItem
				
				getSelectedMenuElementHandle item mH menuId mods parents zIndex (MenuListLSHandle itemHs) tb
					# (found,menuEvent,parents,zIndex,itemHs,tb)	= getSelectedMenuElementHandlesItem item mH menuId mods parents zIndex itemHs tb
					= (found,menuEvent,parents,zIndex,MenuListLSHandle itemHs,tb)
				
				getSelectedMenuElementHandle item mH menuId mods parents zIndex (MenuExtendLSHandle mExH=:{mExtendItems=itemHs}) tb
					# (found,menuEvent,parents,zIndex,itemHs,tb)	= getSelectedMenuElementHandlesItem item mH menuId mods parents zIndex itemHs tb
					= (found,menuEvent,parents,zIndex,MenuExtendLSHandle {mExH & mExtendItems=itemHs},tb)
				
				getSelectedMenuElementHandle item mH menuId mods parents itemNr (MenuChangeLSHandle mChH=:{mChangeItems=itemHs}) tb
					# (found,menuEvent,parents,zIndex,itemHs,tb)	= getSelectedMenuElementHandlesItem item mH menuId mods parents zIndex itemHs tb
					= (found,menuEvent,parents,zIndex,MenuChangeLSHandle {mChH & mChangeItems=itemHs},tb)
				
				getSelectedMenuElementHandle _ _ _ _ parents zIndex itemH tb
					= (False,Nothing,parents,zIndex,itemH,tb)

filterOSEvent _ _ _
	= menueventFatalError "filterOSEvent" "unmatched OSEvent"


//	PA: this function is also defined identically in windowevent.
toModifiers :: !Int -> Modifiers
toModifiers i
	=	{	shiftDown	= shifton
		,	optionDown	= alton
		,	commandDown	= ctrlon
		,	controlDown	= ctrlon
		,	altDown		= alton
		}
where
	shifton	= i bitand SHIFTBIT <> 0
	alton	= i bitand ALTBIT   <> 0
	ctrlon	= i bitand CTRLBIT  <> 0


MenuHandlesGetMenuStateHandles :: !(MenuHandles .ps) -> (![MenuStateHandle .ps],!MenuHandles .ps)
MenuHandlesGetMenuStateHandles mHs=:{mMenus}
	= (mMenus,{mHs & mMenus=[]})

MenuSystemStateGetMenuHandles :: !(DeviceSystemState .ps) -> MenuHandles .ps
MenuSystemStateGetMenuHandles (MenuSystemState mHs)
	= mHs
MenuSystemStateGetMenuHandles _
	= menueventFatalError "MenuSystemStateGetMenuHandles" "argument is no MenuSystemState"
